﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.BusinessData.Runtime;

namespace BCS.Northwind
{
   public class OrderService
   {
      public static IEnumerable<Order> ReadList()
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               var orders = context.Order.ToList();
               return orders;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static Order ReadItem(int orderID)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               var order = context.Order.Where(o => o.OrderID == orderID).SingleOrDefault();
               return order;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static void Update(Order modifiedOrder, int orderID)
      {
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               var order = context.Order.Where(o => o.OrderID == modifiedOrder.OrderID).Single();
               order.UpdateWith(modifiedOrder);
               context.SubmitChanges();
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
      }

      public static IEnumerable<Customer> OrderToCustomer(int orderID)
      {
         Customer customer;
         try
         {
            using (var context = new NorthwindDataContext(Constants.ConnectionString))
            {
               Order order;
               order = (from o in context.Order
                        where o.OrderID == orderID
                        select o).SingleOrDefault();
               customer = order != null ? order.Customer : null;
            }
         }
         catch (Exception ex)
         {
            throw new RuntimeException("Fehler beim Lesen der Datenquelle.", ex);
         }
         yield return customer;
      }
   }
}
